figure1 = figure('Color',[1 1 1],'rend','painters','units','centimeters','pos',[1 1 17 15]);

%%
subplot1 = subplot(2,2,1);        % add first plot in 2 x 2 grid
hold on

%load Data
MyData = esrf110015;
yData = cell2mat(MyData(3:end,2:end));
xData =  cell2mat(MyData(3:end,1));
[a,b] = size(yData);
z = 0;
y2Data(1:a,1) = 0;

%smooth data 
for i = 1:b
    xData(1:a,i) = xData(1:a,1);
    z(1:a,i) = i;
    y2Data(1:end,i) = smooth(yData(1:end,i));
end

%surface map
double xq;
double yq;
double vq;
[xq,yq] = meshgrid(min(real(log10(xData))):.1:max(real(log10(xData))),1:1:a);
P = real(log10(xData));
Q = real(log10(y2Data));
vq = griddata(P,z,Q,xq,yq,'natural');

% Create figure
%figure1 = figure('Color',[1 1 1],'rend','painters','pos',[10 10 500 500]);

% Create axes
%%axes1 = axes('Parent',figure1);
hold(subplot1,'on');
set(gca,'color','none')

% Create surf
surfc(xq,yq,vq,'Parent',subplot1,'EdgeAlpha',0.45);

% Create light
light('Parent',subplot1,'Position',[47.94 8.23999999999998 -2],'Style','infinite');

% Create xlabel
xlabel('Q _{log10} (^{-1})');

% Create ylabel
ylabel('Time (minutes)');

% Create zlabel
zlabel({'','I _{log10} (mm^{-1})',''});

% xyz limits 
zlim(subplot1,[min(min(vq)) max(max(vq))+0.1]);
ylim(subplot1,[0 b]);

xmin = real(log10(min(xData)));
xmax = real(log10(max(xData)));
subplot1.XLim(1) = xmin(1,1);
subplot1.XLim(2) = xmax(1,1);

% axes settings 
view(subplot1,[48 8.24]);
box(subplot1,'on');
grid(subplot1,'on');
axis(subplot1,'square');

% Set the remaining axes properties
set(subplot1,'CLim',[-4 0],'Projection','perspective');
set(subplot1,'FontSize',8);
colormap jet
%%
subplot2 = subplot(2,2,[2 4]);       % add second plot in 2 x 2 grid
set(subplot2,'FontSize',8);
hold on

i = 1;
x1 = cell2mat(TTCF1100(4:end,1))/10;
x2 = cell2mat(TTCF1100_fit(3:end,1));

a = 1;
for n = [2 4 6 8 12 14 16 18 20];
h(n) = plot(x1,cell2mat(TTCF1100(4:end,n))*10^a,'ok','MarkerSize',4);
a = a+.5;
end


a = 1;
for z = [2 4 6 8];
ha(z) = plot(x2,cell2mat(TTCF1100_fit(3:end,z))*10^a,'LineWidth',1.5);    
a = a+.5;
ha(z).Color = [0 1 0];
end

a = 3;
for z = [12 14 16 18 20];
line(z) = plot(x2,cell2mat(TTCF1100_fit(3:end,z))*10^a,'LineWidth',1.5);    
a = a+.5;
line(z).Color = [0 0 1];
end

legend1 = legend([line(20) ha(4) h(2)],{'stage II fit','stage I fit','scattering'});
legend('boxoff');
set(legend1,'FontSize',8);
legend1.Position(1) = legend1.Position(1)+0.1;

% Create xlabel
xla =xlabel('Q (^{-1}) ');

% Create ylabel
yla =ylabel('I(q) (scaled)');

% Uncomment the following line to preserve the X-limits of the axes
 xlim(subplot2,[0.005 0.51]);
% Uncomment the following line to preserve the Y-limits of the axes
 ylim(subplot2,[0.001 25000]);
 
% Set the remaining axes properties
set(subplot2,'LineStyleOrderIndex',2,'XMinorTick','on','XScale','log',...
    'YMinorTick','on','YScale','log');

a = 1;
time = {'','1 min','','3','','6','','9','','','','20','','30','','40','','50','','60'};
for n = [2 4 6 8 12 14 16 18 20];
fittext = text(x2(end,1)+ 0.08,cell2mat(TTCF1100_fit(end,n))*10^a,time(n));
fittext.FontSize = 8;
a = a+.5;
end

set([xla yla gca],'FontSize',8)
% Create textarrow
annotation(figure1,'textarrow',[0.72 0.72],...
    [0.28 0.88],'String',{'time'},'FontSize',9);
%%
subplot3 = subplot(2,2,3);    
set(subplot3,'FontSize',8);

% load data from table
 time1 = cell2mat(calc1100(3:11,18));
 chi1 = cell2mat(calc1100(3:11,6));
 radius_frac1 = cell2mat(calc1100(3:11,14));
cutoff1 = cell2mat(calc1100(3:11,12));
% df1 = cell2mat(calc1100(3:11,17));
% pw1 = cell2mat(calc1100(3:11,5));
rp1 = cell2mat(calc1100(3:11,11));
 re1 = cell2mat(calc1100(3:11,13));
% 
 time2 = cell2mat(calc1100(14:end,18));
chi2 = cell2mat(calc1100(14:end,5));
radius_frac2= cell2mat(calc1100(14:end,13));
% df2 = cell2mat(calc1100(14:end,10));
 cutoff2 = cell2mat(calc1100(14:end,6));
 lorentz2 = cell2mat(calc1100(14:end,15));

 %set labels
xlabel('Time (min)');
ylabel('Radius ()');

%plot data
 [hAx, sc1,sc6] = plotyy(time1,rp1,time1,cutoff1);
 hold(hAx(1),'on');
 hold(hAx(2),'on');
  sc7 = plot(hAx(1,2),time2,cutoff2,'s','Color',[1 1 1],'MarkerSize',5);
 sc9 =  plot(hAx(2),time2,chi2,'^','MarkerSize',5,'Color',[0.4941    0.1843    0.5569]);
sc10 = plot(hAx(2),time1,chi1,'^','MarkerSize',5,'Color',[0.4941    0.1843    0.5569]);
 sc2 = plot(hAx(1),time1,re1,'o','MarkerSize',5,'Color',[0 0 0]);
 sc3 = plot(hAx(1),time1,radius_frac1,'o','MarkerSize',5,'Color',[0 0 0]);
 sc4 = plot(hAx(1),time2,radius_frac2,'o','MarkerSize',5,'Color',[0 0 0]);
 sc5 = plot(hAx(1),time2,lorentz2,'h','MarkerSize',5,'Color',[0 0 0]);
set(sc1,'LineStyle','none','Marker','o','MarkerSize',5,'Color',[0 0 1]);
set(sc6,'LineStyle','none','Marker','s','Color',[0.9294    0.6902    0.1294],'MarkerSize',5);

%format plot
sc1.MarkerFaceColor = [0 0 1];
sc1.MarkerEdgeColor = [0 0 0];
sc6.MarkerEdgeColor = [0.9294    0.6902    0.1294];
sc6.MarkerFaceColor = [1 1 1];
sc7.MarkerEdgeColor = [0.9294    0.6902    0.1294];
sc7.MarkerFaceColor = [1 1 1];
xl = [9.5;9.5];
yl = [5;1000];
sc8 = plot(hAx(1),xl,yl,'-.k');
sc2.MarkerFaceColor = [0 1 0];
sc3.MarkerFaceColor = [1 0 0];
sc4.MarkerFaceColor = [1 0 0];
sc5.MarkerFaceColor = [0.3020    0.7490    0.9294];

%format axes
ylabel(hAx(2),'arbitrary','FontSize',9);
xlabel('Time (min)','FontSize',9);
ylabel(hAx(1),'Radius ()','FontSize',9);
ylim(hAx(1),[0 150]);
set(hAx(1),'YScale','log');
ylim(hAx(2),[0 5]);
xlim(hAx(1),[0 60]);
xlim(hAx(2),[0 60]);
set(hAx,'FontSize',8);
hAx(1).YColor = [0 0 0];
hAx(2).YColor = [0 0 0];
set(hAx(1),'YTick',[0 5 10 20 40 80 160]);
set(hAx(2),'YTick',[0 1 2 3 4 5]);

%legend
l1 = legend([sc1 sc2 sc3  sc5],{'polar','equat','rfrac','lorentz'});
set(l1,'Box','off');
set(l1,'FontSize',8);

l2 = legend([sc6 sc9],{'cut-off','chi^2'});
set(l2,'Box','off');
set(l2,'FontSize',8);

text(0,200,'stage I');
text(30,200,'stage II');
%%
subplot1.Position = [0.095 0.6 0.4 0.4];
subplot2.Position =[0.6 0.095 0.35 0.875];
subplot3.Position = [0.095 0.095 0.375 0.345];
%-------------------------------------------------------------------------
% Create textbox
annotation(figure1,'textbox',...
    [0.05 0.965 0.05 0.05],...
    'String','A',...
    'LineStyle','none',...
    'FontSize',18,...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.525 0.965 0.1 0.05],...
    'String','B',...
    'LineStyle','none',...
    'FontSize',18,...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.05 0.475 0.05 0.05],...
    'String','C',...
    'LineStyle','none',...
    'FontSize',18,...
    'FitBoxToText','off');
%-------------------------------------------------------------------------


set(figure1,'PaperPositionMode','auto');
set(figure1,'PaperSize',[figure1.PaperPosition(3) figure1.PaperPosition(4)]);